using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents VistALink RPC fault message as defined 
	/// in rpcFault.xsd (VistALink protocol specification).
	/// </summary>
	public sealed class RpcFaultMessage : BaseFaultMessage
	{
		/// <summary>
		/// VistALink message type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string MessageType = "gov.va.med.foundations.rpc.fault";

		/// <summary>
		/// VistALink message XSD schema file name string. 		
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string XsdName = "rpcFault.xsd";

		/// <summary>
		/// Contstructor specifying minimal required VistALink RPC fault message parameters. 
		/// </summary>
		/// <param name="faultInfo">Fault info object containing information about the fault.</param>
		public RpcFaultMessage( FaultInfo faultInfo ) 
			: base( MessageType, XsdName, faultInfo ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document</param>
		public RpcFaultMessage( XmlDocument sourceDoc )
			: base( MessageType, XsdName, sourceDoc ) {}
	}
}
